<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'project';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'name', 'start_at', 'end_at', 'total', 'status', 'note', 'link');

	public function services()
	{
		return $this->belongsToMany('Service', 'project_service', 'project_id', 'service_id');
	}

	public function project_services()
	{
		return $this->hasMany('ProjectService', 'project_id');
	}

	public function client()
	{
		return $this->belongsTo('User', 'client_id');
	}

}