<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectServiceField extends Eloquent {

	protected $table = 'project_service_field';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_service_id', 'service_field_id', 'value', 'field_id', 'service_id');

	public function field()
	{
		return $this->belongsTo('Field', 'field_id');
	}

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

}