<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentProfileTable extends Migration {

	public function up()
	{
		Schema::create('Student_Profile', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('student_id')->unsigned();
			$table->bigInteger('education_level_id')->unsigned();
			$table->integer('total_absences')->default('0');
			$table->integer('unexcused_absences')->default('0');
			$table->decimal('score')->nullable();
			$table->text('behavior_notes')->nullable();
			$table->text('health_notes')->nullable();
			$table->json('interests')->nullable();
			$table->json('activities_participated')->nullable();
			$table->json('achievements')->nullable();
			$table->text('guardian_feedback')->nullable();
			$table->json('teacher_feedback')->nullable();
			$table->timestamps();
			$table->json('skills')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Student_Profile');
	}
}