<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Unit extends Model 
{

    protected $table = 'units';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'acronym');
    protected $visible = array('code', 'acronym');

    public function staff()
    {
        return $this->belongsToMany('Staff');
    }

    public function detais()
    {
        return $this->hasMany('UnitDetail');
    }

    public function Course()
    {
        return $this->belongsToMany('Course')->withPivot('year_id', 'schedule_id', 'credits_ects');
    }

}