<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerchantProfilesTable extends Migration {

	public function up()
	{
		Schema::create('merchantProfiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('email', 255);
			$table->string('phone', 50);
			$table->string('business_name', 255);
			$table->string('manager_name', 255);
			$table->string('address', 255);
			$table->string('lat', 255)->nullable();
			$table->string('long', 255)->nullable();
			$table->string('coverImage', 255)->nullable();
			$table->string('logo', 255)->nullable();
			$table->string('tax_number', 255);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('merchantProfiles');
	}
}