<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('driverProfiles', function(Blueprint $table) {
			$table->foreign('vehicle_type')->references('id')->on('vechileTypes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categoryattributes', function(Blueprint $table) {
			$table->foreign('custom_attributes_id')->references('id')->on('custom_attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categoryattributes', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('merchantProfiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('productImages', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('productAttribute', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('productAttribute', function(Blueprint $table) {
			$table->foreign('custom_attributes_id')->references('id')->on('custom_attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('driverProfiles', function(Blueprint $table) {
			$table->dropForeign('driverProfiles_vehicle_type_foreign');
		});
		Schema::table('categoryattributes', function(Blueprint $table) {
			$table->dropForeign('categoryattributes_custom_attributes_id_foreign');
		});
		Schema::table('categoryattributes', function(Blueprint $table) {
			$table->dropForeign('categoryattributes_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_user_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_store_id_foreign');
		});
		Schema::table('productImages', function(Blueprint $table) {
			$table->dropForeign('productImages_product_id_foreign');
		});
		Schema::table('productAttribute', function(Blueprint $table) {
			$table->dropForeign('productAttribute_product_id_foreign');
		});
		Schema::table('productAttribute', function(Blueprint $table) {
			$table->dropForeign('productAttribute_custom_attributes_id_foreign');
		});
	}
}