<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNovaMediaLibraryTable extends Migration {

	public function up()
	{
		Schema::create('nova_media_library', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title')->nullable();
			$table->string('name');
			$table->string('type');
			$table->string('folder');
			$table->tinyInteger('private')->default('0');
			$table->tinyInteger('Ip')->default('0');
			$table->text('options')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nova_media_library');
	}
}