<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryRecord extends Model 
{

    protected $table = 'inventory_record';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'region_id', 'site_id');

    public function site()
    {
        return $this->belongsTo('Site', 'site_id');
    }

    public function region()
    {
        return $this->belongsTo('Region', 'region_id');
    }

}