<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpareItemTable extends Migration {

	public function up()
	{
		Schema::create('spare_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->nullable();
			$table->string('item_name')->nullable();
			$table->integer('amount')->nullable();
			$table->integer('unit_id')->nullable();
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('spare_item');
	}
}