<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'address', 'password', 'area_id', 'api_token');

    public function orders()
    {
        return $this->hasMany('App/Models\Order');
    }

    public function notifiable()
    {
        return $this->morphMany('App/Models\Notification');
    }

    public function tokenable()
    {
        return $this->morphMany('App/Models\Token');
    }

    public function contactable()
    {
        return $this->morphMany('App/Models\Contact');
    }

}