<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;
    protected $fillable = array('name', 'area_id', 'email', 'password', 'delivery_time', 'minimum', 'delivery_cost', 'phone', 'whatsapp', 'img', 'status', 'pin_code', 'api_token');

    public function categories()
    {
        return $this->hasMany('App/Models\Category');
    }

    public function offers()
    {
        return $this->hasMany('App/Models\Offer');
    }

    public function orders()
    {
        return $this->hasMany('App/Models\Order');
    }

    public function transfers()
    {
        return $this->hasMany('App/Models\Transfer');
    }

    public function notifiable()
    {
        return $this->morphMany('App/Models\Notification');
    }

    public function tokenable()
    {
        return $this->morphMany('App/Models\Token');
    }

    public function contactable()
    {
        return $this->morphMany('App/Models\Contact');
    }

}