<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->integer('area_id')->unsigned();
			$table->string('email')->nullable();
			$table->string('password');
			$table->string('delivery_time');
			$table->integer('minimum')->unsigned()->nullable();
			$table->decimal('delivery_cost');
			$table->string('phone');
			$table->string('whatsapp')->nullable();
			$table->string('img')->nullable();
			$table->boolean('status');
			$table->string('pin_code')->nullable();
			$table->string('api_token', 60);
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}