<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBooksTable extends Migration {

	public function up()
	{
		Schema::create('books', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('format')->nullable();
			$table->string('author_name')->nullable();
			$table->boolean('is_emerging_author')->default(true);
			$table->decimal('paper_price')->nullable();
			$table->decimal('paper_discount_price')->nullable();
			$table->integer('paper_quantity')->nullable();
			$table->string('paper_model')->nullable();
			$table->integer('pages')->nullable();
			$table->date('year')->nullable();
			$table->string('language')->nullable();
			$table->string('status')->nullable();
			$table->string('title')->nullable();
			$table->string('description')->nullable();
			$table->string('pricing_model')->nullable();
			$table->decimal('ebook_price')->nullable();
			$table->string('ebook_file_path');
			$table->string('cover_image_path');
			$table->string('publisher')->nullable();
			$table->integer('views')->default('0');
			$table->integer('shares')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('books');
	}
}