<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('country_translations', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('city_translations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('district_translations', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('model_has_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('model_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cultural_entity', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cultural_entity', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cultural_entity', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cultural_entity_type_translations', function(Blueprint $table) {
			$table->foreign('cultural_entity_type_id')->references('id')->on('cultural_entity_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cultural_entity_type_employees', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cultural_entity_type_employees', function(Blueprint $table) {
			$table->foreign('cultural_entity_id')->references('id')->on('cultural_entity')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('catrgory', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('catrgory')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('catrgory_translations', function(Blueprint $table) {
			$table->foreign('book_catrgoriy_id')->references('id')->on('catrgory')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_tag', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_category', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_category', function(Blueprint $table) {
			$table->foreign('catrgory_id')->references('id')->on('catrgory')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_ratings', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_ratings', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_readers', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_readers', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_reviews', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('book_reviews', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paper_book_inventories', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paper_book_inventories', function(Blueprint $table) {
			$table->foreign('statusupdated_by')->references('id')->on('cultural_entity')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('social_login', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plan_features', function(Blueprint $table) {
			$table->foreign('subscription_plan_id')->references('id')->on('subscription_plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plan_discounts', function(Blueprint $table) {
			$table->foreign('subscription_plan_id')->references('id')->on('subscription_plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cultural_entity_subscriptions', function(Blueprint $table) {
			$table->foreign('cultural_entity_id')->references('id')->on('cultural_entity')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cultural_entity_subscriptions', function(Blueprint $table) {
			$table->foreign('subscription_plan_id')->references('id')->on('subscription_plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('country_translations', function(Blueprint $table) {
			$table->dropForeign('country_translations_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('city_translations', function(Blueprint $table) {
			$table->dropForeign('city_translations_city_id_foreign');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->dropForeign('districts_city_id_foreign');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->dropForeign('districts_country_id_foreign');
		});
		Schema::table('district_translations', function(Blueprint $table) {
			$table->dropForeign('district_translations_district_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_country_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_nationality_id_foreign');
		});
		Schema::table('model_has_roles', function(Blueprint $table) {
			$table->dropForeign('model_has_roles_role_id_foreign');
		});
		Schema::table('model_has_permissions', function(Blueprint $table) {
			$table->dropForeign('model_has_permissions_permission_id_foreign');
		});
		Schema::table('cultural_entity', function(Blueprint $table) {
			$table->dropForeign('cultural_entity_city_id_foreign');
		});
		Schema::table('cultural_entity', function(Blueprint $table) {
			$table->dropForeign('cultural_entity_country_id_foreign');
		});
		Schema::table('cultural_entity', function(Blueprint $table) {
			$table->dropForeign('cultural_entity_district_id_foreign');
		});
		Schema::table('cultural_entity_type_translations', function(Blueprint $table) {
			$table->dropForeign('cultural_entity_type_translations_cultural_entity_type_id_foreign');
		});
		Schema::table('cultural_entity_type_employees', function(Blueprint $table) {
			$table->dropForeign('cultural_entity_type_employees_role_id_foreign');
		});
		Schema::table('cultural_entity_type_employees', function(Blueprint $table) {
			$table->dropForeign('cultural_entity_type_employees_cultural_entity_id_foreign');
		});
		Schema::table('catrgory', function(Blueprint $table) {
			$table->dropForeign('catrgory_parent_id_foreign');
		});
		Schema::table('catrgory_translations', function(Blueprint $table) {
			$table->dropForeign('catrgory_translations_book_catrgoriy_id_foreign');
		});
		Schema::table('book_tag', function(Blueprint $table) {
			$table->dropForeign('book_tag_book_id_foreign');
		});
		Schema::table('book_tag', function(Blueprint $table) {
			$table->dropForeign('book_tag_tag_id_foreign');
		});
		Schema::table('book_category', function(Blueprint $table) {
			$table->dropForeign('book_category_book_id_foreign');
		});
		Schema::table('book_category', function(Blueprint $table) {
			$table->dropForeign('book_category_catrgory_id_foreign');
		});
		Schema::table('book_ratings', function(Blueprint $table) {
			$table->dropForeign('book_ratings_book_id_foreign');
		});
		Schema::table('book_ratings', function(Blueprint $table) {
			$table->dropForeign('book_ratings_client_id_foreign');
		});
		Schema::table('book_readers', function(Blueprint $table) {
			$table->dropForeign('book_readers_book_id_foreign');
		});
		Schema::table('book_readers', function(Blueprint $table) {
			$table->dropForeign('book_readers_client_id_foreign');
		});
		Schema::table('book_reviews', function(Blueprint $table) {
			$table->dropForeign('book_reviews_book_id_foreign');
		});
		Schema::table('book_reviews', function(Blueprint $table) {
			$table->dropForeign('book_reviews_client_id_foreign');
		});
		Schema::table('paper_book_inventories', function(Blueprint $table) {
			$table->dropForeign('paper_book_inventories_book_id_foreign');
		});
		Schema::table('paper_book_inventories', function(Blueprint $table) {
			$table->dropForeign('paper_book_inventories_statusupdated_by_foreign');
		});
		Schema::table('social_login', function(Blueprint $table) {
			$table->dropForeign('social_login_client_id_foreign');
		});
		Schema::table('plan_features', function(Blueprint $table) {
			$table->dropForeign('plan_features_subscription_plan_id_foreign');
		});
		Schema::table('plan_discounts', function(Blueprint $table) {
			$table->dropForeign('plan_discounts_subscription_plan_id_foreign');
		});
		Schema::table('cultural_entity_subscriptions', function(Blueprint $table) {
			$table->dropForeign('cultural_entity_subscriptions_cultural_entity_id_foreign');
		});
		Schema::table('cultural_entity_subscriptions', function(Blueprint $table) {
			$table->dropForeign('cultural_entity_subscriptions_subscription_plan_id_foreign');
		});
	}
}