<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePendingActionsTable extends Migration {

	public function up()
	{
		Schema::create('pending_actions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('modelable_id')->unsigned();
			$table->string('modelable_type', 191);
			$table->string('type', 191)->nullable();
			$table->smallInteger('priority')->default('999');
			$table->boolean('dismissible')->default(0);
			$table->boolean('is_seen')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pending_actions');
	}
}