<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfSpecificationsTable extends Migration {

	public function up()
	{
		Schema::create('rf_specifications', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191);
			$table->string('name_en', 191);
			$table->string('type', 191);
			$table->string('icon', 191)->nullable();
			$table->bigInteger('parent_id')->unsigned();
			$table->json('input_details')->nullable();
			$table->boolean('is_active')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rf_specifications');
	}
}