<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfSubLeasesTable extends Migration {

	public function up()
	{
		Schema::create('rf_sub_leases', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('rf_lease_id')->unsigned();
			$table->enum('tenant_type', array('individual', 'company'));
			$table->string('name_ar', 150);
			$table->string('name_en', 150);
			$table->string('registration_no');
			$table->string('tax_identifier_no');
			$table->text('note');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rf_sub_leases');
	}
}