<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('podcasts', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('channels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('channels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('live_streams', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('channels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('podcasts', function(Blueprint $table) {
			$table->dropForeign('podcasts_channel_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_channel_id_foreign');
		});
		Schema::table('live_streams', function(Blueprint $table) {
			$table->dropForeign('live_streams_channel_id_foreign');
		});
	}
}