<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('description');
			$table->enum('status', array('paid', 'free'));
			$table->boolean('offers');
			$table->double('discount');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}