<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstallmentCalcLogsTable extends Migration {

	public function up()
	{
		Schema::create('Installment_calc_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->decimal('unit_price');
			$table->bigInteger('installment_duration_id')->unsigned();
			$table->bigInteger('installment_calc_cycle_id')->unsigned();
			$table->decimal('down_payments');
			$table->decimal('interest_ratio', 8,2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Installment_calc_logs');
	}
}