<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScheduleTable extends Migration {

	public function up()
	{
		Schema::create('schedule', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('type');
			$table->integer('schedulable_id')->unsigned()->index();
			$table->string('schedulable_type')->index();
			$table->timestamp('valid_from');
			$table->timestamp('valid_till');
		});
	}

	public function down()
	{
		Schema::drop('schedule');
	}
}