<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Articulo extends Eloquent {

	protected $table = 'articulo';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function articulo_destino()
	{
		return $this->hasMany('App\Models\ArticuloDestino');
	}

	public function tipo()
	{
		return $this->belongsTo('App\Models\TipoArticulo');
	}

}