<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Destino extends Eloquent {

	protected $table = 'destino';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function articulo_destino()
	{
		return $this->hasMany('App\Models\ArticuloDestino');
	}

	public function tipo()
	{
		return $this->belongsTo('App\Models\TipoDestino');
	}

	public function remito()
	{
		return $this->hasMany('App\Models\Remito');
	}

}