<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Factura extends Eloquent {

	protected $table = 'factura';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function orden()
	{
		return $this->belongsTo('App\Models\OrdenCompra');
	}

	public function detalle()
	{
		return $this->hasOne('App\Models\DetalleFactura');
	}

	public function ordenPagoFactura()
	{
		return $this->hasMany('App\Models\OrdenPagoFactura');
	}

}