<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrdenPago extends Eloquent {

	protected $table = 'orden_pago';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ordenPagoFactura()
	{
		return $this->hasMany('App\Models\OrdenPagoFactura');
	}

	public function proveedor()
	{
		return $this->belongsTo('App\Models\Proveedor');
	}

}