<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrdenPagoFactura extends Eloquent {

	protected $table = 'orden_pago_factura';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function factura()
	{
		return $this->belongsTo('App\Models\Factura');
	}

	public function orden()
	{
		return $this->belongsTo('App\Models\OrdenPago');
	}

}