<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Proveedor extends Eloquent {

	protected $table = 'proveedor';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function remito()
	{
		return $this->hasMany('App\Models\Remito');
	}

	public function orden()
	{
		return $this->hasMany('App\Models\OrdenCompra');
	}

	public function ordenPago()
	{
		return $this->hasMany('App\Models\OrdenPago');
	}

}