<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('property_type_id')->references('id')->on('property_types')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('additional_property_type_id')->references('id')->on('property_types')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('property_attachments', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('user_id_to')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('no action')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_user_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_property_type_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_additional_property_type_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_currency_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_country_id_foreign');
		});
		Schema::table('property_attachments', function(Blueprint $table) {
			$table->dropForeign('property_attachments_property_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_user_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_property_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_user_id_to_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_property_id_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_currency_id_foreign');
		});
	}
}