<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function menus()
    {
        return $this->belongsToMany('App\Menu');
    }

    public function products()
    {
        return $this->hasManyThrough('App\Product', 'App\Subcategory');
    }

    public function subcategories()
    {
        return $this->hasMany('App\Subcategory');
    }

}