<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('price', 'user_id', 'quantity', 'name', 'description', 'subcategory_id');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function subcategory()
	{
		return $this->belongsTo('App\Subcategory');
	}

	public function history()
	{
		return $this->hasMany('App\History');
	}

}