<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChallengesTable extends Migration {

	public function up()
	{
		Schema::create('challenges', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('institution_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('accreditation_id')->unsigned()->nullable();
			$table->bigInteger('episode_type_id')->unsigned()->nullable();
			$table->string('name', 256);
			$table->string('description', 4096);
			$table->string('internal_text', 1024);
			$table->integer('credits');
			$table->boolean('accreditation_approved');
			$table->integer('s1');
			$table->integer('s2');
			$table->integer('s3');
			$table->integer('s4');
			$table->integer('s5');
			$table->integer('s6');
			$table->integer('s7');
			$table->integer('s8');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('challenges');
	}
}