<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentGroupTable extends Migration {

	public function up()
	{
		Schema::create('student_group', function(Blueprint $table) {
			$table->bigInteger('student_id')->unsigned();
			$table->bigInteger('group_id')->unsigned();
			$table->enum('access', array('private', 'limited', 'public'));
			$table->enum('usage', array('favourite', 'interesting', 'others'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('student_group');
	}
}