<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('institution_id')->unsigned()->nullable();
			$table->string('name', 128);
			$table->string('surname', 128);
			$table->string('prefix', 64);
			$table->string('suffix', 64);
			$table->string('email', 256)->unique();
			$table->string('phone', 16);
			$table->integer('bonus_volume');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('bonus_limit')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}