<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigInteger('user_id');
			$table->string('name');
			$table->bigInteger('registration');
			$table->date('admission');
			$table->string('doc');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('manager_id')->unsigned();
			$table->bigInteger('occupation_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}