<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventParticipantTable extends Migration {

	public function up()
	{
		Schema::create('event_participant', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('role', 20)->nullable();
			$table->boolean('is_paid')->default(0);
			$table->tinyInteger('status');
			$table->integer('event_id')->unsigned();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('event_participant');
	}
}