<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 150);
			$table->text('detail')->nullable();
			$table->string('location', 150)->nullable();
			$table->string('latitude', 30)->nullable();
			$table->string('longitude', 30)->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->string('cover_photo_path', 150)->nullable();
			$table->smallInteger('max_seat')->nullable();
			$table->date('reg_last_date')->nullable();
			$table->tinyInteger('event_type')->default('1');
			$table->tinyInteger('status');
			$table->integer('hosted_by')->unsigned();
			$table->boolean('is_paid')->default(0);
			$table->float('price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}