<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 120);
			$table->integer('vacancies')->default('1');
			$table->enum('nature', array('fulltime', 'part-time', 'negotiable'))->nullable();
			$table->string('working_experience_time', 20)->nullable();
			$table->string('keywords', 100)->nullable();
			$table->integer('salary')->default('0');
			$table->string('location', 100)->nullable();
			$table->string('featured_photo', 100)->nullable();
			$table->integer('company_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}