<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorksTable extends Migration {

	public function up()
	{
		Schema::create('works', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 80);
			$table->string('company_name', 100);
			$table->integer('company_id')->unsigned();
			$table->string('start_at', 25)->nullable();
			$table->string('end_at', 25)->nullable();
			$table->string('location', 100)->nullable();
			$table->string('url', 100)->nullable();
			$table->tinyInteger('status')->default('0');
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('works');
	}
}