<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comment extends Eloquent {

	protected $table = 'comments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->belongsTo('App\Models\Status');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

}