<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMaintenancesTable extends Migration {

	public function up()
	{
		Schema::create('maintenances', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('mechanic_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->integer('bicycle_id')->unsigned();
			$table->datetime('date');
			$table->datetime('due_date')->nullable();
			$table->string('status');
			$table->string('observations')->nullable();
			$table->string('description')->nullable();
			$table->string('parts')->nullable();
			$table->double('total', 15,4)->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('maintenances');
	}
}