<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function has_transaction()
	{
		return $this->hasOne('Transaction');
	}

	public function has_customer()
	{
		return $this->hasOne('Customer');
	}

}