<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_branch_mall', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_branch_mall', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_branch_mall', function(Blueprint $table) {
			$table->foreign('mall_id')->references('id')->on('malls')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_company_id_foreign');
		});
		Schema::table('company_branch_mall', function(Blueprint $table) {
			$table->dropForeign('company_branch_mall_company_id_foreign');
		});
		Schema::table('company_branch_mall', function(Blueprint $table) {
			$table->dropForeign('company_branch_mall_branch_id_foreign');
		});
		Schema::table('company_branch_mall', function(Blueprint $table) {
			$table->dropForeign('company_branch_mall_mall_id_foreign');
		});
	}
}