<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('salon_id')->unsigned();
			$table->integer('user_id')->nullable();
			$table->datetime('start_time');
			$table->datetime('end_time');
			$table->integer('customer_id')->unsigned();
			$table->float('total');
			$table->string('status');
			$table->float('amount');
			$table->float('discount_amount');
			$table->string('payment_method');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}