<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'type', 'image', 'country_id');
	protected $hidden = array('password');

	public function country()
	{
		return $this->belongsTo('App\Models\Country');
	}

	public function contacts()
	{
		return $this->hasMany('App\Models\Contact');
	}

	public function dreamQueries()
	{
		return $this->hasMany('App\Models\DreamQuery');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function messages()
	{
		return $this->hasMany('App\Models\Message');
	}

	public function transactions()
	{
		return $this->hasMany('App\Models\Transaction');
	}

	public function blogs()
	{
		return $this->hasMany('App\Models\Blog');
	}

}