<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientExtraFieldTable extends Migration {

	public function up()
	{
		Schema::create('patient_extra_field', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->enum('field_type', array('int', 'string', 'double', 'select'));
			$table->integer('patient_id');
			$table->text('view');
			$table->integer('clinic_id');
		});
	}

	public function down()
	{
		Schema::drop('patient_extra_field');
	}
}