<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('mall_id')->unsigned()->nullable()->index();
			$table->boolean('store_state')->nullable();
			$table->date('start_date')->nullable();
			$table->string('type', 10);
			$table->string('en_name', 255);
			$table->string('ar_name', 255);
			$table->string('en_short_description', 255);
			$table->text('ar_short_description');
			$table->text('en_long_description');
			$table->text('ar_long_description');
			$table->string('sketch', 255);
			$table->string('phone', 255);
			$table->string('email', 255);
			$table->boolean('is_pin');
			$table->boolean('is_gold');
			$table->boolean('is_add');
			$table->integer('rate');
			$table->timestamps();
			$table->date('CreatedAt')->nullable();
			$table->string('UpdatedAt')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}