<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('main_category_id');
			$table->integer('city_id')->unsigned();
			$table->string('lat')->nullable();
			$table->string('long')->nullable();
			$table->date('date')->nullable();
			$table->time('time')->nullable();
			$table->integer('persons_num')->nullable();
			$table->integer('provider_id');
			$table->integer('hours_num');
			$table->longText('description');
			$table->integer('payment_method_id');
			$table->integer('user_id')->unsigned();
			$table->integer('status');
			$table->double('vat');
			$table->double('total_price');
			$table->double('person_price');
			$table->string('order_num');
			$table->string('refuse_reason')->nullable();
			$table->string('cancel_reason')->nullable();
			$table->text('notes')->nullable();
			$table->integer('subcategory_id')->unsigned()->nullable();
			$table->double('price')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}