<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMrInfoTable extends Migration {

	public function up()
	{
		Schema::create('mr_info', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('legal_case_id')->unsigned();
			$table->datetime('body_corporate_consent_due_date');
			$table->string('body_corporate_consent_status');
			$table->string('body_corporate_consent_note');
			$table->string('buyer_letting_license_status');
			$table->string('buyer_letting_license_license_number');
			$table->datetime('buyer_letting_license_obtain_date');
			$table->datetime('buyer_letting_license_due_date');
			$table->integer('letting_pool_count');
			$table->integer('total_lots');
			$table->integer('lots_in_letting_pool');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('mr_info');
	}
}