<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Statistics extends Model 
{

    protected $table = 'statistics';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cam_id', 'timestamp_id');

    public function cam()
    {
        return $this->belongsTo('Cam');
    }

    public function timestamp()
    {
        return $this->hasOne('Timestamp');
    }

}