<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExhaustpipesTable extends Migration {

	public function up()
	{
		Schema::create('exhaustpipes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('address', 255);
			$table->string('city', 255);
			$table->string('province', 255);
			$table->enum('type', array('IND', 'AMD', 'ASDOM'));
			$table->date('authorization_date');
			$table->date('expiration_date');
			$table->enum('frequency', array('monthly', 'bimestrial', 'quarterly', 'half-yearly', 'annual'));
		});
	}

	public function down()
	{
		Schema::drop('exhaustpipes');
	}
}